/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.snmp.SnmpTrapInterface;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BaseSnmpTrapImpl
implements SnmpTrapInterface {
    private static final String TRAPS_CONFIG_FILE = "snmp.trapsconfig.properties";
    private static final String TRACE_MASKT = "XSNMPTIT";
    private static final String TRACE_MASKD = "XSNMPTID";
    private static final String TRACE_MASKF = "XSNMPTIF";

    public Map getSnmpTraps() {
        Trace.trace(TRACE_MASKT, "-> BaseSnmpTrapImpl.getSnmpTraps()");
        HashMap<String, LocalizableText> map = new HashMap<String, LocalizableText>();
        try {
            File file = new File(BaseFileControl.getFilePath(TRAPS_CONFIG_FILE) + TRAPS_CONFIG_FILE);
            if (file.exists() && file.canRead()) {
                Properties props = new Properties();
                FileInputStream fin = new FileInputStream(file);
                props.load(fin);
                fin.close();
                Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    Trace.trace(TRACE_MASKF, "BaseSnmpTrapImpl: adding " + key + " = " + val);
                    map.put(key, new LocalizableText(val));
                }
            } else {
                Trace.trace(TRACE_MASKF, "BaseSnmpTrapImpl: traps config file didn't exist or couldn't read");
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "BaseSnmpTrapImpl: Error finding location of traps config file");
            Trace.trace(TRACE_MASKF, e);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "BaseSnmpTrapImpl: Error reading traps config file");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- BaseSnmpTrapImpl.getSnmpTraps()");
        return map;
    }
}

